/* -*- pse-c -*-
 * Filename: iegd_interface.c
 * $Revision: 1.16 $
 *----------------------------------------------------------------------------
 * <>
 * Copyright  2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *
 *----------------------------------------------------------------------------
 * Functions:
 *
 *
 *----------------------------------------------------------------------------
 */

#ifndef _GART_GLOBAL_DEF
#define _GART_GLOBAL_DEF
#include "igd_gart.h"
#include "igd_abs.h"
#include "interface_abs.h"


#define APER_ENTRY(a,b) sizeof((a))/(b)
#define AGP_DCACHE_MEMORY 1
#define AGP_PHYS_MEMORY   2

#define IEGD "IEGD"

/**
 * This is global data that is shared across file. New global
 * data should goes here.
 */
extern gart_dispatch_t *gart_id;
extern dev_private_data_t private_data;
extern struct pci_device_id iegd_pci_table[];
extern dispatch_table_t driver_dispatch_list[];
extern struct gatt_mask iegd_cmn_masks[];
extern struct aper_size_info_fixed iegd_i915_sizes[];
extern struct aper_size_info_fixed iegd_iq35_sizes[];
extern struct aper_size_info_fixed iegd_i965_sizes[];
extern struct aper_size_info_fixed intel_i830_sizes[];
extern struct aper_size_info_fixed intel_i810_sizes[];
extern struct aper_size_info_fixed iegd_igm45_sizes[];

/* All dispatch table for the chipset family goes here */
extern bridge_driver_t drv_alm;
extern bridge_driver_t drv_nap;
extern bridge_driver_t drv_gn4;
extern bridge_driver_t drv_gm45;

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,5)
/* Poulsbo */
extern struct aper_size_info_fixed iegd_plb_sizes[];
extern bridge_driver_t drv_plb;

/* Poulsbo specific structure so that the DRM can utilize the
 * AGP's virtual aperture management code
 */
extern struct vm_operations_struct iegd_plb_vm_ops;
#endif


/*
 * Macro to fill device information for PCI devices registration.
 * Copy from public agpgart in kernel source
 */
#define ID(x) {						            \
	.class		= (PCI_CLASS_BRIDGE_HOST << 8),	\
	.class_mask	= ~0,				            \
	.vendor		= PCI_VENDOR_ID_INTEL,		    \
	.device		= x,				            \
	.subvendor	= PCI_ANY_ID,			        \
	.subdevice	= PCI_ANY_ID,			        \
}

#ifdef CONFIG_AGP_DEBUG
#define AGN_DEBUG(x,y...) printk(KERN_ALERT "[" IEGD \
		":DEBUG]:%s " x "\n", __FUNCTION__, ##y)
#else
#define AGN_DEBUG(x,y...) do {} while(0)
#endif

#define AGN_ERROR(x,y...) printk(KERN_ALERT "[" IEGD \
		":ERROR]:%s: " x "\n", __FUNCTION__, ##y)
#define AGN_LOG(x,y...) printk(KERN_ALERT "[" IEGD "]: " x "\n", ##y)

/**
 * Global extern function prototype, basically common function
 * should goes here. Most of this function extern is from
 * drv_cmn.c
 */
extern int iegd_find_device(u16 device);
extern struct pci_dev *iegd_probe_device(void);
extern void iegd_cmn_init_gtt_entries(void);
extern int AGP_FREE_GATT(iegd_cmn_free_gatt_table);
extern void iegd_cmn_free_by_type(struct agp_memory *curr);
extern struct agp_memory *iegd_cmn_alloc_by_type(
	size_t pg_count, int type);
extern int iegd_cmn_insert_entries(struct agp_memory *mem,
	off_t pg_start, int type);
extern int iegd_cmn_remove_entries(struct agp_memory *mem, off_t pg_start,
	int type);
extern int bridge_driver_init(bridge_driver_t **driver_hook,
	unsigned short did, dispatch_table_t *list );

#ifndef MSR_IA32_CR_PAT
#define MSR_IA32_CR_PAT 0x0277
#endif
#ifndef _PAGE_PAT
#define _PAGE_PAT 0x080
#endif
extern void agp_init_pat(void);
extern int agp_use_pat (void);

/**
 * masking valid bit for page table entries before
 * put it insert it to gtt table
 */
unsigned long AGP_MASK_MEMORY(iegd_cmn_mask_memory);
int AGP_CREATE_GATT(iegd_alm_create_gatt_table);
extern int iegd_cmn_configure(void);
extern void AGP_ENABLE(iegd_cmn_agp_enable);

/* Global DRM function prototype */
extern int  intel_init(void);
extern void intel_exit(void);
extern int  drm_init(void);
extern void drm_cleanup(void);

/* Generic function to dispatch the information according to
 * chipset id */
static __inline void *dispatch_acquire(

	unsigned short did,
	dispatch_table_t *table_list) {

	dispatch_table_t *curr = table_list;
	while(curr && (curr->did != 0)) {
		if(curr->did == did) {
			return curr->table;
		}
		curr++;
	}

	return NULL;
}
#endif
