// StartNavigationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "StartNavigation.h"
#include "StartNavigationDlg.h"
#define USE_LOADLIBRARY
#include "TNSRemoteInterfaceDll.h"

#ifdef UNICODE
#define CSTRING2W(CSTRING) CSTRING
#define W2CSTRING(WSTRING) WSTRING
#define CSTRING2A(CSTRING) W2A(CSTRING)
#define A2CSTRING(ASTRING) A2W(ASTRING)
#else
#define CSTRING2W(CSTRING) A2W(CSTRING)
#define W2CSTRING(WSTRING) W2A(WSTRING)
#define CSTRING2A(CSTRING) CSTRING
#define A2CSTRING(ASTRING) ASTRING
#endif

LPARAM GetUniqueID()
{
	//generate unique ID
	static LPARAM id = 0;
	if (++id == 0) ++id; // do not use 0 !!!!!
	return id;
}

inline LRESULT RI_MESSAGE( const UINT request, HWND h_client, LPARAM id )
{
	//send message to ri.dll
	if ( !IsWindow( RI_GetTNS() ) ) 
		return RI_NAVIGATIONNOTACTIVE;
	//send the request
	PostMessage( RI_GetTNS(), request, WPARAM(h_client), id );
	return RI_NOERROR;
}

/////////////////////////////////////////////////////////////////////////////
// CStartNavigationDlg dialog

CStartNavigationDlg::CStartNavigationDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStartNavigationDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStartNavigationDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CStartNavigationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStartNavigationDlg)
	DDX_Text(pDX, IDC_ADDRESSSTRING, m_straddress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStartNavigationDlg, CDialog)
	//{{AFX_MSG_MAP(CStartNavigationDlg)
	ON_BN_CLICKED(IDC_STARTNAV, OnStartnav)
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStartNavigationDlg message handlers

BOOL CStartNavigationDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	SetDlgItemText(IDC_ADDRESSSTRING, L"D,76131,Karlsruhe,Stumpfstrasse,1");
		
	return TRUE;  // return TRUE  unless you set the focus to a control
}

LRESULT CStartNavigationDlg::WindowProc ( UINT  message , WPARAM  wParam , LPARAM  lParam )
{
	//check messages for answer from RI
	if ( message == RI_MESSAGE_SEARCHADDRESS )
	{
		if ( (LRESULT)wParam == RI_NOERROR )
		{
			//add the coordinate to the stationlist
			// get the data from the shared memory
			RI_CSearchAddress data;
			RI_CAddStopOffPoint temp;
			LRESULT read_suc = RI_SearchAddress_ReadData( lParam, data );
			//copy the data from struct RI_CSearchAddress to the struct RI_CAddStopOffPoint
			temp.m_mercator_x = data.m_mercator_x;
			temp.m_mercator_y = data.m_mercator_y;
			wcscpy(temp.m_Caption, L"RI-Request");
			wcscpy(temp.m_Description, L"RI-Request");
			LPARAM id = GetUniqueID();
			//*** write data in shared memory ***
			LRESULT sharing_ret = RI_AddStopOffPoint_WriteData( id, temp );
			if ( sharing_ret != RI_NOERROR ) 
				ErrorMsg(2);

			if ( RI_MESSAGE( RI_MESSAGE_ADDSTOPPOFFPOINT, GetSafeHwnd(), id ) == RI_NOERROR )
				ErrorMsg(0);
			else
				ErrorMsg(2);
		}
	}
	if ( message == RI_MESSAGE_STARTNAVIGATION )
	{
		if ( (LRESULT)wParam == RI_NOERROR )
		{
			ErrorMsg(3);
		}
		else
		{
			ErrorMsg(2);
		}
	}
    if ( message == RI_MESSAGE_SWITCHMAP )
	{
		if ( (LRESULT)wParam == RI_NOERROR )
		{
			//geocode address string to coordinate
			GetDlgItemText(IDC_ADDRESSSTRING,m_straddress);
			RI_CSearchAddress data;
			LPARAM id = GetUniqueID();
			wcscpy(data.m_address, CSTRING2W(m_straddress));
			//*** write data in shared memory ***
			LRESULT sharing_ret = RI_SearchAddress_WriteData( id, data );
			if ( sharing_ret != RI_NOERROR ) 
				ErrorMsg(2);
			if ( RI_MESSAGE( RI_MESSAGE_SEARCHADDRESS, GetSafeHwnd(), id ) == RI_NOERROR )
				ErrorMsg(0);
			else
				ErrorMsg(2);
    	}
		else
			ErrorMsg(2);
	}
	if ( message == RI_MESSAGE_BLOCKUSERINTERACTION )
	{
		if ( (LRESULT)wParam == RI_NOERROR )
		{
			//Set the navigation software to the main menu
			if ( RI_MESSAGE( RI_MESSAGE_ROLLBACKTOMAINMENU, GetSafeHwnd(), GetUniqueID() ) == RI_NOERROR )
				ErrorMsg(0);
			else
				ErrorMsg(2);
		}
		else
		{
			ErrorMsg(2);
		}
	}
	if ( message == RI_MESSAGE_ALLOWUSERINTERACTION )
	{
		if ( (LRESULT)wParam == RI_NOERROR )
		{
			//Enable the Button "StartNavigation"
			GetDlgItem(IDC_STARTNAV)->EnableWindow(true);
			ErrorMsg(0);
		}
		else
		{
			ErrorMsg(2);
		}
	}
	if ( message == RI_MESSAGE_ROLLBACKTOMAINMENU )
	{
		if ( (LRESULT)wParam == RI_NOERROR )
		{
			//read the address-string
			GetDlgItemText(IDC_ADDRESSSTRING,m_straddress);
			int pos = m_straddress.Find(L",",0);
			CString tmp = m_straddress.Mid(0,pos);
			CString map = SwitchMap(tmp);
			//Switch the map
			RI_CSwitchMap data;
			LPARAM id = GetUniqueID();
			//*** copy data ***
			wcscpy(data.m_MapName,map);
			//*** write data in shared memory ***
			LRESULT sharing_ret = RI_SwitchMap_WriteData( id, data);
			if ( sharing_ret != RI_NOERROR ) 
				ErrorMsg(2);
			
			if ( RI_MESSAGE( RI_MESSAGE_SWITCHMAP, GetSafeHwnd(), id ) == RI_NOERROR )
				ErrorMsg(0);
			else
				ErrorMsg(2);
		}
		else
		{
			ErrorMsg(2);
		}
	}
	if ( message == RI_MESSAGE_ADDSTOPPOFFPOINT )
	{
		if ( (LRESULT)wParam == RI_NOERROR )
		{
			LPARAM id = GetUniqueID();
			//send the message to start the navigation
			if ( RI_MESSAGE( RI_MESSAGE_STARTNAVIGATION, GetSafeHwnd(), id ) == RI_NOERROR )
				ErrorMsg(0);
			else
				ErrorMsg(2);
		}
		else
			ErrorMsg(2);
	}
	return CDialog::WindowProc( message, wParam, lParam );
}

void CStartNavigationDlg::OnStartnav() 
{
	//Disable the Button "StartNavigation"
	GetDlgItem(IDC_STARTNAV)->EnableWindow(false);
	//Send the message to disable the user interaction on the navigation software
	if ( RI_MESSAGE( RI_MESSAGE_BLOCKUSERINTERACTION, GetSafeHwnd(), GetUniqueID() ) == RI_NOERROR )
		ErrorMsg(0);
	else
		ErrorMsg(1);
}
void CStartNavigationDlg::ErrorMsg(int msg)
{
	//Errorhandling
	switch (msg)
	{
		case 0:
			//do nothing!!
			break;
		case 1:
			AfxMessageBox(L"Navigator is not running!", MB_OK);
			GetDlgItem(IDC_STARTNAV)->EnableWindow(true);
			break;
		case 2:
			//Error, show Message and enable User Interaction
			AfxMessageBox(L"RI-Error!", MB_OK);
			if ( RI_MESSAGE( RI_MESSAGE_ALLOWUSERINTERACTION, GetSafeHwnd(), GetUniqueID() ) == RI_NOERROR )
				ErrorMsg(0);
			else
				ErrorMsg(2);
			break;
		case 3:
			//No Errors enable User Interaction
			if ( RI_MESSAGE( RI_MESSAGE_ALLOWUSERINTERACTION, GetSafeHwnd(), GetUniqueID() ) == RI_NOERROR )
				ErrorMsg(0);
			else
				ErrorMsg(2);
			break;
		default:
			break;
	}
}
CString CStartNavigationDlg::SwitchMap(CString tmp)
{
	//Convert countrycode to map
	CString map;
	if (tmp == "D")
		map = L"deu_08Q2";
	else if (tmp == "F")
		map = L"fra_08Q2";
	else
		map = L"";
	return map;
}

void CStartNavigationDlg::OnQuit() 
{
	//quit the application
	OnCancel();	
}
